#include "ImplicitMidpointEquationSolver.h"

double ImplicitMidpointEquationSolver::FindSolution(double f(double, double), double yn, double xn, double h, double start, double stop, double tol) {
  _f = f;
  _yn = yn;
  _xn = xn;
  _h = h;
  return bisez(start, stop, tol);
}

double ImplicitMidpointEquationSolver::fzero(double ynp1) {
  // it solves equations of the form ynp1 = yn + h*f(xn+0.5*h, 0.5*(yn+ynp1))
  // finding the "zero" of the equation below
  //  printf("ynp1=%f = yn=%f + %f*f(xn=%f+0.5*%f, yn=%f + ynp1=%f)\n", ynp1, _yn, _h, _xn, _h, _yn, ynp1);
  return ynp1-(_yn+_h*_f(_xn+0.5*_h, 0.5*(_yn+ynp1)));
}
