//e' meglio mettere gli include dove vengono "usati" (i.e. nel .C)
//dato che non c'e' motivo di "esporli" nel .h
#include "Rectangle.h"
#include <math.h>
#include <gsl/gsl_math.h>
#include <stdio.h>
#include <limits>

Rectangle::Rectangle(double b, double h){
#ifdef __DEBUG__
  printf("New rectangle created!\n");
#endif
  
  setBaseHeight(b, h);
  
  return;
}

Rectangle::Rectangle(const Rectangle& rec2){
#ifdef __DEBUG__
  printf("New rectangle created, as copy!\n");
#endif
  
  setBaseHeight(rec2.base, rec2.height);
  
  return;
}

Rectangle::~Rectangle(){
#ifdef __DEBUG__
  printf("Rectangle destroyed!\n");
#endif
  
  return;
}

void Rectangle::setBaseHeight(double b, double h) {
  
  base=b;
  height=h;

  return;
}

double Rectangle::getDiag() {
  //  return sqrt(base*base + height*height);
  //  return TMath::Sqrt(base*base + height*height);
  return gsl_hypot(base, height);
}

Rectangle* Rectangle::Merge(const Rectangle& rec1, const Rectangle& rec2){

  Rectangle* ret = NULL;//se per caso il metodo non può creare il nuovo rettangolo viene ritornato un puntatore NULL, che è una condizione "controllabile" da parte del "client"...
  
  double _min_double = std::numeric_limits<double>::min();
  //  printf("%E\n", _min_double);
  
  if (fabs(rec1.base - rec2.base)<_min_double) {//questo succede anche se i due rettangoli sono uguali
    ret = new Rectangle(rec1.base, rec1.height+rec2.height);
  }
  else if (fabs(rec1.height - rec2.height)<_min_double) {
    ret = new Rectangle(rec1.base+rec2.base, rec1.height);
  }
  else {
    printf("%s::The two rectangles have not any side that is equal: cannot be merged!\n", __FUNCTION__);
  }

  return ret;
}

Rectangle Rectangle::Sum(const Rectangle& rec1, const Rectangle& rec2){

  Rectangle ret(rec1.base+rec2.base, rec1.height+rec2.height);

  return ret;//questo crea una copia dell'oggetto! L'oggetto originale IN TEORIA è distrutto!
  //(in alcuni compilatori la cosa è "ottimizzata" e in realtà non viene distrutto: Name Return Value Optimization)
}

Rectangle Rectangle::operator+(const Rectangle& rec2){

  Rectangle ret(base+rec2.base, height+rec2.height);

  return ret;//questo crea una copia dell'oggetto! L'oggetto originale IN TEORIA è distrutto!
  //(in alcuni compilatori la cosa è "ottimizzata" e in realtà non viene distrutto: Name Return Value Optimization)
}

Rectangle Rectangle::operator=(const Rectangle& rec2){
    
  Rectangle ret(rec2.base, rec2.height);

  return ret;//questo crea una copia dell'oggetto! L'oggetto originale IN TEORIA è distrutto!
  //(in alcuni compilatori la cosa è "ottimizzata" e in realtà non viene distrutto: Name Return Value Optimization)
}
