class Rectangle {

 public:
  Rectangle(double b=1, double h=1); //costrutture ('constructor')
  Rectangle(const Rectangle& rec2); //costruttore di copia ('copy constructor'). Esiste anche se non definito/implementato: instanzia un oggetto con tutti i membri uguali a quello passato
  ~Rectangle(); //distruttore ('destructor')

  void setBaseHeight(double b, double h);
  // 'inline' istruisce il compilatore di sostituire il contenuto della funzione con la sua chiamata.
  // Questo evita di saltare qua e la per lo stack, rallentando il programma.
  // Ha senso solo se la funzione e' piccola: altrimenti l'eseguibile diventa di size piu' grande
  inline double getArea() { return base*height; };
  inline void setBase(double b) { base=b; };
  inline double getBase() { return base; };
  inline void setHeight(double h) { height=h; };
  inline double getHeight() { return height; };

  // passando gli oggetti per referenza (i.e. 'rec&'), si evita di copiare tutto l'oggetto (operazione lenta)
  // e si passa semplicemente la referenza (~ il puntatore) alla funzione
  // passando il riferimento/puntatore, però, la funzione potrebbe modificare l'oggetto, che non e' desiderato:
  // passando per referenza (invece che passare il puntatore) e mettendo 'const' previene la modifica dell'oggetto passato.
  // Mettere 'const' in una funzione che passa il puntatore, invece, previene solo che il puntatore stesso venga modificato
  // (modifica che comunque non avrebbe effetto a meno di non passare la referenza al puntatore, i.e. 'Rectangle* prec&').
  static Rectangle* Merge(const Rectangle& rec1, const Rectangle& rec2);
  static Rectangle Sum(const Rectangle& rec1, const Rectangle& prec2);
  Rectangle operator+(const Rectangle& rec2);
  Rectangle operator=(const Rectangle& rec2);
  
  double getDiag();
  
 private:
  //membri di classe
  double base;
  double height;

};
