#include <iostream>
#include <cmath>
#include <vector>
#include "TRandom.h"
#include "TRandom1.h"
#include "TRandom2.h"
#include "TRandom3.h"
#include "TMath.h"
#include "TGraph.h"
#include "TH1F.h"
#include "TCanvas.h"
#include "TF1.h"
#include "TApplication.h"

void fillUniform(TH1* h, TRandom* rand, int nentries, double min=0.0, double max=1.0){

  for (int ii=0; ii<nentries; ii++) {
    double nr = rand->Uniform(min, max);
    h->Fill(nr);
  }

  return;
}

void fillGauss(TH1* h, TRandom* rand, int nentries, double mean=0.0, double sigma=1.0){

  for (int ii=0; ii<nentries; ii++) {
    double nr = rand->Gaus(mean, sigma);
    h->Fill(nr);
  }

  return;
}

void fillExpo(TH1* h, TRandom* rand, int nentries, double tau=-1.0){

  for (int ii=0; ii<nentries; ii++) {
    double nr = rand->Exp(tau);
    h->Fill(nr);
  }

  return;
}

int main(int argc, char* argv[]) {

  TApplication *myapp=new TApplication("myapp",0,0);

  TRandom3* rand = new TRandom3();

  //--------------------------------------------------------------------
  
  TH1F* h_unif = new TH1F("unif", "unif;x (u.a.);Entries", 100, 0, 10);
  h_unif->SetLineColor(kBlack);
  h_unif->SetLineWidth(3.0);
  TH1F* h_gaus = new TH1F("gaus", "gaus;x (u.a.);Entries", 100, 0, 10);
  h_gaus->SetLineColor(kRed+1);
  h_gaus->SetLineWidth(3.0);
  TH1F* h_expo = new TH1F("expo", "expo;x (u.a.);Entries", 100, 0, 10);
  h_expo->SetLineColor(kBlue+1);
  h_expo->SetLineWidth(3.0);

  fillUniform(h_unif, rand, 5000, 0.0, 10.0);
  fillGauss(h_gaus, rand, 5000, 5.0, 1.0);
  fillExpo(h_expo, rand, 5000, 1.0/3.0);
  
  TCanvas* c_one = new TCanvas("one", "One"); 
  c_one->cd();
  c_one->SetLogy();
  h_expo->Draw();
  h_gaus->Draw("same");
  h_unif->Draw("same");
  c_one->Modified();
  c_one->Update();

  //--------------------------------------------------------------------

  double tail_start=0.0;
  double tail_stop=30.0;
  TH1F* h_tail = new TH1F("tail", "tail;Events in [-#infty, #mu-3#sigma];Entries", int(tail_stop-tail_start), tail_start, tail_stop);
  h_tail->SetLineColor(kBlack);
  h_tail->SetLineWidth(3.0);

  int nprove=1000;
  
  TGraph* gr_tail = new TGraph(nprove);
  gr_tail->SetLineColor(kBlack);
  gr_tail->SetMarkerColor(kBlack);
  gr_tail->SetMarkerStyle(20);

  for (int pp=0; pp<nprove; pp++) {
    double mu=5.0;
    double sigma=1.0;
    TH1F h_gaus("gaus2", "gaus;x (u.a.);Entries", 100, 0, 10);
    fillGauss(&h_gaus, rand, 5000, mu, sigma);
    double eit = h_gaus.Integral(0, h_gaus.FindBin(mu-3*sigma));
    h_tail->Fill(eit);
    gr_tail->SetPoint(pp, pp, eit);
  }

  TCanvas* c_twoA = new TCanvas("twoA", "TwoA"); 
  c_twoA->cd();
  c_twoA->SetLogy();
  h_tail->Draw();
  h_tail->Fit("gaus", "+");
  h_tail->GetFunction("gaus")->SetLineColor(kRed+1);
  h_tail->GetFunction("gaus")->SetLineWidth(3);
  h_tail->Fit("landau", "+");
  h_tail->GetFunction("landau")->SetLineColor(kBlue+1);
  h_tail->GetFunction("landau")->SetLineWidth(3);
  //  TF1* pois = new TF1("pois", "[0]*TMath::PoissonI(x, [1])", tail_start, tail_stop);
  TF1* pois = new TF1("pois", "[0]*TMath::Poisson(int(x), [1])", tail_start, tail_stop);
  pois->SetLineColor(kGreen+1);
  pois->SetLineWidth(3);
  pois->SetParName(0, "Norm");
  pois->SetParName(1, "#nu");
  pois->SetNpx(1000);
  pois->SetParameter(0, h_tail->GetEntries()/h_tail->GetBinWidth(0));
  pois->SetParameter(1, h_tail->GetMean());
  h_tail->Fit(pois, "+");
  c_twoA->Modified();
  c_twoA->Update();
  
  TCanvas* c_twoB = new TCanvas("twoB", "TwoB"); 
  c_twoB->cd();
  gr_tail->Draw("AP");
  gr_tail->Fit("pol1");
  gr_tail->GetFunction("pol1")->SetLineColor(kRed+1);
  gr_tail->GetFunction("pol1")->SetLineWidth(3);
  c_twoB->Modified();
  c_twoB->Update();
  
  myapp->Run();
  
  return 0;
}
