#include <iostream>
#include <cmath>
#include <vector>

#include "TRandom.h"
#include "TRandom1.h"
#include "TRandom2.h"
#include "TRandom3.h"
#include "TMath.h"
#include "TGraph.h"
#include "TH1F.h"
#include "TF1.h"
#include "TCanvas.h"
#include "TAxis.h"
#include "TLegend.h"
#include "TLegendEntry.h"
#include "TList.h"
#include "TApplication.h"

#include "ODEIntegrator.h"

//equazioni da integrare
double funEqExp(double, double);
double funEqPol2(double, double);
double funEqPol4(double, double);
double funEqPol5(double, double);

/////////////////////////////////////////////////////

double funEqExp(double x, double y) {
  return y;
}

double funEqPol2(double x, double y) {
  return 2.0*x;
}

double funEqPol4(double x, double y) {
  return 4.0*pow(x, 3.0);
}

double funEqPol5(double x, double y) {
  return 5.0*pow(x, 4.0);
}

/////////////////////////////////////////////////////

int main(int argc, char* argv[]) {
  
  TApplication* myapp=new TApplication("myapp",0,0);
  
  {
    double xmin=0; double xmax=4; double y0=1; double step=1.0;
    
    TCanvas* c = new TCanvas();
    c->cd();
    TH1F* h = c->DrawFrame(0, 0, 4.5, 90);
    h->GetXaxis()->SetTitle("x");
    h->GetYaxis()->SetTitle("y");
  
    {
      printf("****** Exponential *************\n");
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqExp, xmin, xmax, y0, step);
	printf("%s: %f\n", "Eulero", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kRed+1);
	gr->SetMarkerColor(kRed+1);
	gr->SetLineWidth(3);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("MidpointEsplicito", gr, funEqExp, xmin, xmax, y0, step);
	printf("%s: %f\n", "MidpointEsplicito", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("MidpointEsplicito", "MidpointEsplicito");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kBlue+1);
	gr->SetMarkerColor(kBlue+1);
	gr->SetLineWidth(4);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("MidpointImplicito", gr, funEqExp, xmin, xmax, y0, step);
	printf("%s: %f\n", "MidpointImplicito", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("MidpointImplicito", "MidpointImplicito");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kGreen+1);
	gr->SetMarkerColor(kGreen+1);
	gr->SetLineWidth(2);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("RK4", gr, funEqExp, xmin, xmax, y0, step);
	printf("%s: %f\n", "RK4", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("RK4", "RK4");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kOrange+1);
	gr->SetMarkerColor(kOrange+1);
	gr->SetLineWidth(3);
      }
      TF1* fExp = new TF1("fExp", "exp(x)", xmin, xmax);
      fExp->Draw("same");
      fExp->SetLineColor(kBlack);
      fExp->SetLineWidth(3);
      fExp->SetNpx(100);
      printf("analitico: %f\n", fExp->Eval(xmax));
    }

    TLegend* leg = c->BuildLegend(0.13, 0.67, 0.5, 0.88);
    TList* lop = leg->GetListOfPrimitives();
    for (int ii=0; ii<lop->GetEntries(); ii++) {
      TLegendEntry* obj = (TLegendEntry*)(lop->At(ii));
      TString name = obj->GetLabel();
      //      printf("%s\n", name.Data());
      if (name=="hframe") {
	lop->Remove(obj);
      }
    }
    c->Update();
    c->Modified();
  }
  
  {
    double xmin=0; double xmax=4; double y0=1;
    
    TCanvas* c = new TCanvas();
    c->cd();
    TH1F* h = c->DrawFrame(0, 0, 4.5, 90);
    h->GetXaxis()->SetTitle("x");
    h->GetYaxis()->SetTitle("y");
    
    {
      printf("****** Exponential *************\n");
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqExp, xmin, xmax, y0, 1.0);
	printf("%s: %f\n", "Eulero (h=1.0)", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero (h=1.0)");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kRed+1);
	gr->SetMarkerColor(kRed+1);
	gr->SetLineWidth(3);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqExp, xmin, xmax, y0, 0.5);
	printf("%s: %f\n", "Eulero (h=0.5)", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero (h=0.5)");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kBlue+1);
	gr->SetMarkerColor(kBlue+1);
	gr->SetLineWidth(2);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqExp, xmin, xmax, y0, 0.25);
	printf("%s: %f\n", "Eulero (h=0.25)", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero (h=0.25)");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kGreen+1);
	gr->SetMarkerColor(kGreen+1);
	gr->SetLineWidth(3);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqExp, xmin, xmax, y0, 0.125);
	printf("%s: %f\n", "Eulero (h=0.125)", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero (h=0.125)");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kOrange+1);
	gr->SetMarkerColor(kOrange+1);
	gr->SetLineWidth(3);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqExp, xmin, xmax, y0, 0.0625);
	printf("%s: %f\n", "Eulero (h=0.0625)", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero (h=0.0625)");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kCyan);
	gr->SetMarkerColor(kCyan);
	gr->SetLineWidth(3);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqExp, xmin, xmax, y0, 0.03125);
	printf("%s: %f\n", "Eulero (h=0.03125)", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero (h=0.03125)");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kMagenta);
	gr->SetMarkerColor(kMagenta);
	gr->SetLineWidth(3);
      }
      TF1* fExp = new TF1("fExp", "exp(x)", xmin, xmax);
      fExp->Draw("same");
      fExp->SetLineColor(kBlack);
      fExp->SetLineWidth(3);
      fExp->SetNpx(100);
      printf("analitico: %f\n", fExp->Eval(xmax));
    }

    TLegend* leg = c->BuildLegend(0.13, 0.67, 0.5, 0.88);
    TList* lop = leg->GetListOfPrimitives();
    for (int ii=0; ii<lop->GetEntries(); ii++) {
      TLegendEntry* obj = (TLegendEntry*)(lop->At(ii));
      TString name = obj->GetLabel();
      //      printf("%s\n", name.Data());
      if (name=="hframe") {
	lop->Remove(obj);
      }
    }
    c->Update();
    c->Modified();
  }

  {
    double xmin=0; double xmax=4; double y0=0; double step=0.25;
    
    TCanvas* c = new TCanvas();
    c->cd();
    TH1F* h = c->DrawFrame(0, -1, 4.5, 20);
    h->GetXaxis()->SetTitle("x");
    h->GetYaxis()->SetTitle("y");
  
    {
      printf("****** x^2 *************\n");
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqPol2, xmin, xmax, y0, step);
	printf("%s: %f\n", "Eulero", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kRed+1);
	gr->SetMarkerColor(kRed+1);
	gr->SetLineWidth(3);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("MidpointEsplicito", gr, funEqPol2, xmin, xmax, y0, step);
	printf("%s: %f\n", "MidpointEsplicito", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("MidpointEsplicito", "MidpointEsplicito");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kBlue+1);
	gr->SetMarkerColor(kBlue+1);
	gr->SetLineWidth(4);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("MidpointImplicito", gr, funEqPol2, xmin, xmax, y0, step);
	printf("%s: %f\n", "MidpointImplicito", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("MidpointImplicito", "MidpointImplicito");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kGreen+1);
	gr->SetMarkerColor(kGreen+1);
	gr->SetLineWidth(2);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("RK4", gr, funEqPol2, xmin, xmax, y0, step);
	printf("%s: %f\n", "RK4", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("RK4", "RK4");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kOrange+1);
	gr->SetMarkerColor(kOrange+1);
	gr->SetLineWidth(2);
      }
      TF1* fPol2 = new TF1("fPol2", "pow(x,2)", xmin, xmax);
      fPol2->Draw("same");
      fPol2->SetLineColor(kBlack);
      fPol2->SetLineWidth(3);
      fPol2->SetNpx(100);
      printf("analitico: %f\n", fPol2->Eval(xmax));
    }

    TLegend* leg = c->BuildLegend(0.13, 0.67, 0.5, 0.88);
    TList* lop = leg->GetListOfPrimitives();
    for (int ii=0; ii<lop->GetEntries(); ii++) {
      TLegendEntry* obj = (TLegendEntry*)(lop->At(ii));
      TString name = obj->GetLabel();
      //      printf("%s\n", name.Data());
      if (name=="hframe") {
	lop->Remove(obj);
      }
    }
    c->Update();
    c->Modified();
  }

  {
    double xmin=0; double xmax=4; double y0=0; double step=0.25;
    
    TCanvas* c = new TCanvas();
    c->cd();
    TH1F* h = c->DrawFrame(0, -1, 4.5, 260);
    h->GetXaxis()->SetTitle("x");
    h->GetYaxis()->SetTitle("y");
    
    {
      printf("****** x^4 *************\n");
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqPol4, xmin, xmax, y0, step);
	printf("%s: %f\n", "Eulero", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kRed+1);
	gr->SetMarkerColor(kRed+1);
	gr->SetLineWidth(3);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("MidpointEsplicito", gr, funEqPol4, xmin, xmax, y0, step);
	printf("%s: %f\n", "MidpointEsplicito", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("MidpointEsplicito", "MidpointEsplicito");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kBlue+1);
	gr->SetMarkerColor(kBlue+1);
	gr->SetLineWidth(4);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("MidpointImplicito", gr, funEqPol4, xmin, xmax, y0, step);
	printf("%s: %f\n", "MidpointImplicito", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("MidpointImplicito", "MidpointImplicito");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kGreen+1);
	gr->SetMarkerColor(kGreen+1);
	gr->SetLineWidth(2);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("RK4", gr, funEqPol4, xmin, xmax, y0, step);
	printf("%s: %f\n", "RK4", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("RK4", "RK4");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kOrange+1);
	gr->SetMarkerColor(kOrange+1);
	gr->SetLineWidth(2);
      }
      TF1* fPol4 = new TF1("fPol4", "pow(x,4)", xmin, xmax);
      fPol4->Draw("same");
      fPol4->SetLineColor(kBlack);
      fPol4->SetLineWidth(3);
      fPol4->SetNpx(100);
      printf("analitico: %f\n", fPol4->Eval(xmax));
    }

    TLegend* leg = c->BuildLegend(0.13, 0.67, 0.5, 0.88);
    TList* lop = leg->GetListOfPrimitives();
    for (int ii=0; ii<lop->GetEntries(); ii++) {
      TLegendEntry* obj = (TLegendEntry*)(lop->At(ii));
      TString name = obj->GetLabel();
      //      printf("%s\n", name.Data());
      if (name=="hframe") {
	lop->Remove(obj);
      }
    }
    c->Update();
    c->Modified();
  }

  {
    double xmin=0; double xmax=4; double y0=0; double step=0.25;
    
    TCanvas* c = new TCanvas();
    c->cd();
    TH1F* h = c->DrawFrame(0, -1, 4.5, 1100);
    h->GetXaxis()->SetTitle("x");
    h->GetYaxis()->SetTitle("y");
    
    {
      printf("****** x^5 *************\n");
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("Eulero", gr, funEqPol5, xmin, xmax, y0, step);
	printf("%s: %f\n", "Eulero", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("Eulero", "Eulero");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kRed+1);
	gr->SetMarkerColor(kRed+1);
	gr->SetLineWidth(3);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("MidpointEsplicito", gr, funEqPol5, xmin, xmax, y0, step);
	printf("%s: %f\n", "MidpointEsplicito", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("MidpointEsplicito", "MidpointEsplicito");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kBlue+1);
	gr->SetMarkerColor(kBlue+1);
	gr->SetLineWidth(4);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("MidpointImplicito", gr, funEqPol5, xmin, xmax, y0, step);
	printf("%s: %f\n", "MidpointImplicito", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("MidpointImplicito", "MidpointImplicito");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kGreen+1);
	gr->SetMarkerColor(kGreen+1);
	gr->SetLineWidth(2);
      }
      {
	TGraph* gr = new TGraph();
	double solatxmax = ODEIntegrator::odeint("RK4", gr, funEqPol5, xmin, xmax, y0, step);
	printf("%s: %f\n", "RK4", solatxmax);
	gr->Draw("PL");
	gr->SetNameTitle("RK4", "RK4");
	gr->SetFillColor(kWhite);
	gr->SetLineColor(kOrange+1);
	gr->SetMarkerColor(kOrange+1);
	gr->SetLineWidth(2);
      }
      TF1* fPol5 = new TF1("fPol5", "pow(x,5)", xmin, xmax);
      fPol5->Draw("same");
      fPol5->SetLineColor(kBlack);
      fPol5->SetLineWidth(3);
      fPol5->SetNpx(100);
      printf("analitico: %f\n", fPol5->Eval(xmax));
    }

    TLegend* leg = c->BuildLegend(0.13, 0.67, 0.5, 0.88);
    TList* lop = leg->GetListOfPrimitives();
    for (int ii=0; ii<lop->GetEntries(); ii++) {
      TLegendEntry* obj = (TLegendEntry*)(lop->At(ii));
      TString name = obj->GetLabel();
      //      printf("%s\n", name.Data());
      if (name=="hframe") {
	lop->Remove(obj);
      }
    }
    c->Update();
    c->Modified();
  }
  
  myapp->Run();
  
  return 0;
}
