#include <math.h>

#include "EquationSolver.h"

double EquationSolver::FindSolution(double f(double), double lhs, double start, double stop, double tol) {
  _f = f;
  _lhs = lhs;
  return bisez(start, stop, tol);
}

double EquationSolver::fzero(double x) {
  return _lhs-_f(x);
}

double EquationSolver::bisez(double a, double b, double tol) {
  
  bool trovato=false;
  double yc=0, xc=0, delta=fabs(b-a);
  double ya=fzero(a), yb=fzero(b);

  //  printf("f(%f)=%f, f(%f)=%f\n", a, ya, b, yb);
  
  while (( delta>=tol && !trovato )) {
    xc=(a+b)/2;
    yc=fzero(xc);
    if (yc*ya<0) {
      // nuovi estremi a, c
      b=xc;
      yb=yc;
    }
    else if (yc*yb<0) {
      // nuovi estremi c, b
      a=xc;
      ya=yc;
    }
    else if (yc==0) {
      trovato=true;
    }
    delta=fabs(b-a);
    //    printf("f(%f)=%f delta=%f\n", xc, yc, delta);
  }
  
  return xc;
}
