#ifndef _ODEINTEGRATOR_
#define _ODEINTEGRATOR_

#include "ImplicitMidpointEquationSolver.h"

//metodi di risoluzione
double metodoEulero(           TGraph* gr, double f(double, double), double xmin, double xmax, double y0, double step=1);
double metodoMidpointEsplicito(TGraph* gr, double f(double, double), double xmin, double xmax, double y0, double step=1);
double metodoMidpointImplicito(TGraph* gr, double f(double, double), double xmin, double xmax, double y0, double step=1);
double metodoRK4(              TGraph* gr, double f(double, double), double xmin, double xmax, double y0, double step=1);

class ODEIntegrator {

typedef double (*funcp)(TGraph* gr, double f(double, double), double, double, double, double);
  
public:
  ODEIntegrator(const std::string method="RK4");
  
  static double odeint(const std::string method, TGraph* gr, double f(double, double), double xmin, double xmax, double y0, double step=1);
  static double odeint(const std::string method,             double f(double, double), double xmin, double xmax, double y0, double step=1);
  double        odeint(                          TGraph* gr, double f(double, double), double xmin, double xmax, double y0, double step=1);
  double        odeint(                                      double f(double, double), double xmin, double xmax, double y0, double step=1);

  void SetMethod(const std::string method);
  
private:
  funcp _fi;
  std::string _method;
};

#endif
