#include "Rectangle.h"
#include <stdio.h> //printf

int main(int argc, char* argv[]) {
    
  Rectangle* prec1 = new Rectangle();
  if (prec1)
    printf("  rec1) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec1->getBase(), prec1->getHeight(), prec1->getDiag(), prec1->getArea());

  prec1->setBaseHeight(3, 4);
  if (prec1) 
    printf("  rec1) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec1->getBase(), prec1->getHeight(), prec1->getDiag(), prec1->getArea());

  prec1->setBase(2);
  prec1->setHeight(6);
  if (prec1) 
    printf("  rec1) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec1->getBase(), prec1->getHeight(), prec1->getDiag(), prec1->getArea());

  printf("\n");
  
  Rectangle* prec2 = new Rectangle(3, 6);
  if (prec2) 
    printf("  rec2) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec2->getBase(), prec2->getHeight(), prec2->getDiag(), prec2->getArea());
  Rectangle* prec1m2 = Rectangle::Merge(*prec1, *prec2);
  if (prec1m2) 
    printf("rec1m2) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec1m2->getBase(), prec1m2->getHeight(), prec1m2->getDiag(), prec1m2->getArea());
  Rectangle rec1p2 = Rectangle::Sum(*prec1, *prec2);
  printf("rec1p2) Base=%f, Height=%f --> Diag=%f, Area=%f\n", rec1p2.getBase(), rec1p2.getHeight(), rec1p2.getDiag(), rec1p2.getArea());

  printf("\n");
  
  Rectangle* prec3 = new Rectangle(rec1p2);
  if (prec3) 
    printf("  rec3) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec3->getBase(), prec3->getHeight(), prec3->getDiag(), prec3->getArea());
  prec3->setBaseHeight(2, 4);
  if (prec3) 
    printf("  rec3) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec3->getBase(), prec3->getHeight(), prec3->getDiag(), prec3->getArea());
  Rectangle* prec1m3 = Rectangle::Merge(*prec1, *prec3);
  if (prec1m3) 
    printf("rec1m3) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec1m3->getBase(), prec1m3->getHeight(), prec1m3->getDiag(), prec1m3->getArea());
  Rectangle rec1p3 = (*prec1)+(*prec3);
  printf("rec1p3) Base=%f, Height=%f --> Diag=%f, Area=%f\n", rec1p3.getBase(), rec1p3.getHeight(), rec1p3.getDiag(), rec1p3.getArea());

  printf("\n");
  
  Rectangle rec4(*prec1);
  printf("  rec4) Base=%f, Height=%f --> Diag=%f, Area=%f\n", rec4.getBase(), rec4.getHeight(), rec4.getDiag(), rec4.getArea());
  rec4.setBaseHeight(3,5);
  printf("  rec4) Base=%f, Height=%f --> Diag=%f, Area=%f\n", rec4.getBase(), rec4.getHeight(), rec4.getDiag(), rec4.getArea());
  Rectangle* prec14 = Rectangle::Merge(*prec1, rec4);
  if (prec14) 
    printf("  rec14) Base=%f, Height=%f --> Diag=%f, Area=%f\n", prec14->getBase(), prec14->getHeight(), prec14->getDiag(), prec14->getArea());

  if (prec1) delete prec1;
  if (prec2) delete prec2;
  if (prec1m2) delete prec1m2;
  if (prec3) delete prec3;
  if (prec1m3) delete prec1m3;
  if (prec14) delete prec14;
  
  return 0;
}
